@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  print-client startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and PRINT_CLIENT_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\print-client-0.0.1-SNAPSHOT.jar;%APP_HOME%\lib\iTextAsian.jar;%APP_HOME%\lib\vertx-web-client-4.3.2.jar;%APP_HOME%\lib\vertx-web-4.3.2.jar;%APP_HOME%\lib\vertx-lang-kotlin-4.3.2.jar;%APP_HOME%\lib\vertx-lang-kotlin-coroutines-4.3.2.jar;%APP_HOME%\lib\vertx-sql-client-templates-4.3.2.jar;%APP_HOME%\lib\vertx-jdbc-client-4.3.2.jar;%APP_HOME%\lib\h2-1.4.200.jar;%APP_HOME%\lib\netty-resolver-dns-native-macos-4.1.78.Final-osx-x86_64.jar;%APP_HOME%\lib\jasperreports-functions-6.17.0.jar;%APP_HOME%\lib\jasperreports-6.17.0.jar;%APP_HOME%\lib\commons-vfs2-2.9.0.jar;%APP_HOME%\lib\hadoop-hdfs-client-3.3.1.jar;%APP_HOME%\lib\vertx-sql-client-4.3.2.jar;%APP_HOME%\lib\vertx-web-common-4.3.2.jar;%APP_HOME%\lib\vertx-auth-common-4.3.2.jar;%APP_HOME%\lib\vertx-bridge-common-4.3.2.jar;%APP_HOME%\lib\vertx-uri-template-4.3.2.jar;%APP_HOME%\lib\vertx-core-4.3.2.jar;%APP_HOME%\lib\jackson-core-2.13.2.jar;%APP_HOME%\lib\jackson-annotations-2.13.2.jar;%APP_HOME%\lib\jackson-databind-2.13.2.1.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.5.2.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.5.31.jar;%APP_HOME%\lib\slf4j-api-1.7.32.jar;%APP_HOME%\lib\log4j-core-2.16.0.jar;%APP_HOME%\lib\log4j-api-kotlin-1.1.0.jar;%APP_HOME%\lib\log4j-api-2.16.0.jar;%APP_HOME%\lib\agroal-pool-1.13.jar;%APP_HOME%\lib\agroal-api-1.13.jar;%APP_HOME%\lib\javase-3.4.1.jar;%APP_HOME%\lib\sqlite-jdbc-3.36.0.3.jar;%APP_HOME%\lib\itext-asian-5.2.0.jar;%APP_HOME%\lib\jasperreports-fonts-6.17.0.jar;%APP_HOME%\lib\barcode4j-2.1.jar;%APP_HOME%\lib\batik-bridge-1.11.jar;%APP_HOME%\lib\pdfbox-2.0.22.jar;%APP_HOME%\lib\icu4j-70.1.jar;%APP_HOME%\lib\rxjava-3.1.5.jar;%APP_HOME%\lib\font-support-noto-0.0.1-SNAPSHOT.jar;%APP_HOME%\lib\jsoup-1.15.1.jar;%APP_HOME%\lib\netty-resolver-dns-classes-macos-4.1.78.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.78.Final.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.78.Final.jar;%APP_HOME%\lib\netty-codec-http2-4.1.78.Final.jar;%APP_HOME%\lib\netty-codec-http-4.1.78.Final.jar;%APP_HOME%\lib\netty-handler-4.1.78.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.78.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.78.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.78.Final.jar;%APP_HOME%\lib\netty-codec-4.1.78.Final.jar;%APP_HOME%\lib\netty-transport-4.1.78.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.78.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.78.Final.jar;%APP_HOME%\lib\netty-common-4.1.78.Final.jar;%APP_HOME%\lib\commons-digester-2.1.jar;%APP_HOME%\lib\commons-beanutils-1.9.4.jar;%APP_HOME%\lib\castor-xml-1.4.1.jar;%APP_HOME%\lib\commons-cli-1.0.jar;%APP_HOME%\lib\batik-script-1.11.jar;%APP_HOME%\lib\batik-anim-1.11.jar;%APP_HOME%\lib\batik-gvt-1.11.jar;%APP_HOME%\lib\batik-svg-dom-1.11.jar;%APP_HOME%\lib\batik-parser-1.11.jar;%APP_HOME%\lib\batik-awt-util-1.11.jar;%APP_HOME%\lib\batik-dom-1.11.jar;%APP_HOME%\lib\batik-css-1.11.jar;%APP_HOME%\lib\xmlgraphics-commons-2.3.jar;%APP_HOME%\lib\fontbox-2.0.22.jar;%APP_HOME%\lib\castor-core-1.4.1.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-lang3-3.12.0.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.5.31.jar;%APP_HOME%\lib\kotlin-stdlib-1.5.31.jar;%APP_HOME%\lib\core-3.4.1.jar;%APP_HOME%\lib\jcommander-1.78.jar;%APP_HOME%\lib\jai-imageio-core-1.4.0.jar;%APP_HOME%\lib\commons-collections4-4.2.jar;%APP_HOME%\lib\itext-2.1.7.js8.jar;%APP_HOME%\lib\jfreechart-1.0.19.jar;%APP_HOME%\lib\jcommon-1.0.23.jar;%APP_HOME%\lib\ecj-3.21.0.jar;%APP_HOME%\lib\joda-time-2.9.9.jar;%APP_HOME%\lib\avalon-framework-impl-4.2.0.jar;%APP_HOME%\lib\ant-1.7.1.jar;%APP_HOME%\lib\batik-xml-1.11.jar;%APP_HOME%\lib\batik-util-1.11.jar;%APP_HOME%\lib\xml-apis-ext-1.3.04.jar;%APP_HOME%\lib\reactive-streams-1.0.4.jar;%APP_HOME%\lib\c3p0-0.9.5.5.jar;%APP_HOME%\lib\okhttp-2.7.5.jar;%APP_HOME%\lib\annotations-13.0.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.5.31.jar;%APP_HOME%\lib\commons-collections-3.2.2.jar;%APP_HOME%\lib\bcprov-jdk15on-1.64.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\commons-lang-1.0.jar;%APP_HOME%\lib\ant-launcher-1.7.1.jar;%APP_HOME%\lib\batik-ext-1.11.jar;%APP_HOME%\lib\xalan-2.7.2.jar;%APP_HOME%\lib\serializer-2.7.2.jar;%APP_HOME%\lib\xml-apis-1.3.04.jar;%APP_HOME%\lib\batik-constants-1.11.jar;%APP_HOME%\lib\batik-i18n-1.11.jar;%APP_HOME%\lib\commons-io-1.3.1.jar;%APP_HOME%\lib\mchange-commons-java-0.2.19.jar;%APP_HOME%\lib\okio-1.6.0.jar;%APP_HOME%\lib\junit-3.7.jar


@rem Execute print-client
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %PRINT_CLIENT_OPTS%  -classpath "%CLASSPATH%" io.vertx.core.Launcher %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable PRINT_CLIENT_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%PRINT_CLIENT_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
