/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import com.ittx.cbt.print.client.util.jasper.JasperRenderUtils;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRCommonImage;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintElement;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.util.StyleUtil;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.ResourcePathKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private static final Log log = LogFactory.getLog(JRFillImage.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_SOURCE_CLASS = "fill.image.unknown.source.class";
    private JRGroup evaluationGroup;
    private net.sf.jasperreports.renderers.Renderable renderer;
    private net.sf.jasperreports.renderers.Renderable oldRenderer;
    private Object prevSource;
    private net.sf.jasperreports.renderers.Renderable prevRenderer;
    private boolean usedCache;
    private boolean hasOverflowed;
    private Integer imageHeight;
    private Integer imageWidth;
    private Integer imageX;
    private Integer bookmarkLevel;
    private String anchorName;
    private String hyperlinkReference;
    private Boolean hyperlinkWhen;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected final JRLineBox initLineBox;
    protected JRLineBox lineBox;

    protected JRFillImage(JRBaseFiller filler, JRImage image, JRFillObjectFactory factory) {
        super(filler, (JRGraphicElement)image, factory);
        this.initLineBox = image.getLineBox().clone((JRBoxContainer)this);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage image, JRFillCloneFactory factory) {
        super((JRFillGraphicElement)image, factory);
        this.initLineBox = image.getLineBox().clone((JRBoxContainer)this);
        this.evaluationGroup = image.evaluationGroup;
    }

    protected void evaluateStyle(byte evaluation) throws JRException {
        super.evaluateStyle(evaluation);
        this.lineBox = null;
        if (this.providerStyle != null) {
            this.lineBox = this.initLineBox.clone((JRBoxContainer)this);
            StyleUtil.appendBox((JRLineBox)this.lineBox, (JRLineBox)this.providerStyle.getLineBox());
        }
    }

    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public ScaleImageEnum getScaleImageValue() {
        return this.getStyleResolver().getScaleImageValue((JRCommonImage)this);
    }

    public ScaleImageEnum getOwnScaleImageValue() {
        return this.providerStyle == null || this.providerStyle.getOwnScaleImageValue() == null ? ((JRImage)this.parent).getOwnScaleImageValue() : this.providerStyle.getOwnScaleImageValue();
    }

    public void setScaleImage(ScaleImageEnum scaleImage) {
        throw new UnsupportedOperationException();
    }

    public RotationEnum getRotation() {
        return this.getStyleResolver().getRotation((JRCommonImage)this);
    }

    public RotationEnum getOwnRotation() {
        return this.providerStyle == null || this.providerStyle.getOwnRotationValue() == null ? ((JRImage)this.parent).getOwnRotation() : this.providerStyle.getOwnRotationValue();
    }

    public void setRotation(RotationEnum rotation) {
        throw new UnsupportedOperationException();
    }

    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign((JRImageAlignment)this);
    }

    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.providerStyle == null || this.providerStyle.getOwnHorizontalImageAlign() == null ? ((JRImage)this.parent).getOwnHorizontalImageAlign() : this.providerStyle.getOwnHorizontalImageAlign();
    }

    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign((JRImageAlignment)this);
    }

    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.providerStyle == null || this.providerStyle.getOwnVerticalImageAlign() == null ? ((JRImage)this.parent).getOwnVerticalImageAlign() : this.providerStyle.getOwnVerticalImageAlign();
    }

    public void setVerticalImageAlign(VerticalImageAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    public Boolean getUsingCache() {
        return ((JRImage)this.parent).getUsingCache();
    }

    public void setUsingCache(boolean isUsingCache) {
    }

    public void setUsingCache(Boolean isUsingCache) {
    }

    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    public void setLazy(boolean isLazy) {
    }

    public OnErrorTypeEnum getOnErrorTypeValue() {
        return ((JRImage)this.parent).getOnErrorTypeValue();
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        throw new UnsupportedOperationException();
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRImage)this.parent).getEvaluationTimeValue();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRLineBox getLineBox() {
        return this.lineBox == null ? this.initLineBox : this.lineBox;
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRImage)this.parent).getHyperlinkTypeValue();
    }

    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    public String getLinkTarget() {
        return ((JRImage)this.parent).getLinkTarget();
    }

    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    public JRExpression getBookmarkLevelExpression() {
        return ((JRImage)this.parent).getBookmarkLevelExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkWhenExpression() {
        return ((JRImage)this.parent).getHyperlinkWhenExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected net.sf.jasperreports.renderers.Renderable getRenderable() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        return (JRTemplateImage)this.getElementTemplate();
    }

    protected JRTemplateElement createElementTemplate() {
        JRTemplateImage template = new JRTemplateImage(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), (JRImage)this);
        if (this.getScaleImageValue() == ScaleImageEnum.REAL_HEIGHT || this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
            template.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        }
        return template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.bookmarkLevel = JRFillImage.getBookmarkLevel((Object)this.evaluateExpression(this.getBookmarkLevelExpression(), evaluation));
            if (this.isEvaluateNow()) {
                this.hasOverflowed = false;
                this.evaluateImage(evaluation);
            }
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.evaluateStyle(evaluation);
        JRExpression expression = this.getExpression();
        net.sf.jasperreports.renderers.Renderable newRenderer = null;
        Boolean isUsingCache = this.getUsingCache();
        this.usedCache = isUsingCache == null ? true : isUsingCache;
        Object source = null;
        try {
            source = this.evaluateExpression(expression, evaluation);
        }
        catch (Exception e) {
            source = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).handleImageError(e, this.getOnErrorTypeValue());
        }
        if (source != null) {
            if (isUsingCache == null) {
                isUsingCache = source instanceof String;
                this.usedCache = isUsingCache;
            }
            boolean lazy = this.isLazy();
            RepositoryContext repositoryContext = this.filler.getRepositoryContext();
            Object srcKey = source;
            if (source instanceof String) {
                ResourcePathKey pathKey = ResourcePathKey.inContext((RepositoryContext)(lazy ? null : repositoryContext), (String)((String)source));
                srcKey = new Pair((Object)lazy, (Object)pathKey);
            }
            if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedRenderer(srcKey)) {
                newRenderer = this.filler.fillContext.getLoadedRenderer(srcKey);
            } else {
                JRRenderable deprecatedRenderable;
                JRRenderable jRRenderable = deprecatedRenderable = source instanceof JRRenderable ? (JRRenderable)source : null;
                if (source instanceof String) {
                    String strSource = (String)source;
                    if (lazy) {
                        newRenderer = ResourceRenderer.getInstance((String)strSource, (boolean)true);
                    } else {
                        ResourceInfo resourceInfo = RepositoryUtil.getInstance((RepositoryContext)repositoryContext).getResourceInfo((String)source);
                        if (resourceInfo == null) {
                            if (strSource.startsWith("http") || strSource.startsWith("https")) {
                                strSource = JasperRenderUtils.INSTANCE.encodeChineseUrl(strSource);
                            }
                            newRenderer = RendererUtil.getInstance((RepositoryContext)repositoryContext).getNonLazyRenderable(strSource, this.getOnErrorTypeValue());
                        } else {
                            String absoluteLocation = resourceInfo.getRepositoryResourceLocation();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("image " + source + " resolved to " + absoluteLocation));
                            }
                            ResourcePathKey absolutePathKey = ResourcePathKey.absolute((String)absoluteLocation);
                            Pair absoluteKey = new Pair((Object)lazy, (Object)absolutePathKey);
                            if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedRenderer((Object)absoluteKey)) {
                                newRenderer = this.filler.fillContext.getLoadedRenderer((Object)absoluteKey);
                            } else {
                                newRenderer = RendererUtil.getInstance((RepositoryContext)repositoryContext).getNonLazyRenderable(absoluteLocation, this.getOnErrorTypeValue());
                                if (isUsingCache.booleanValue()) {
                                    this.filler.fillContext.registerLoadedRenderer((Object)absoluteKey, newRenderer);
                                }
                            }
                        }
                    }
                } else if (source instanceof Image) {
                    Image img = (Image)source;
                    newRenderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getRenderable(img, this.getOnErrorTypeValue());
                } else if (source instanceof byte[]) {
                    byte[] data = (byte[])source;
                    newRenderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getRenderable(data);
                } else if (source instanceof InputStream) {
                    if (this.prevSource != null && source == this.prevSource) {
                        newRenderer = this.prevRenderer;
                    } else {
                        InputStream is = (InputStream)source;
                        newRenderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getRenderable(is, this.getOnErrorTypeValue());
                    }
                } else if (source instanceof URL) {
                    URL url = (URL)source;
                    newRenderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getRenderable(url, this.getOnErrorTypeValue());
                } else if (source instanceof File) {
                    File file = (File)source;
                    newRenderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getRenderable(file, this.getOnErrorTypeValue());
                } else if (source instanceof net.sf.jasperreports.renderers.Renderable) {
                    newRenderer = (net.sf.jasperreports.renderers.Renderable)source;
                } else if (deprecatedRenderable != null) {
                    Renderable wrappingRenderable = RenderableUtil.getWrappingRenderable((JRRenderable)deprecatedRenderable);
                    newRenderer = wrappingRenderable;
                } else {
                    newRenderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getOnErrorRenderer(this.getOnErrorTypeValue(), new JRException(EXCEPTION_MESSAGE_KEY_UNKNOWN_SOURCE_CLASS, new Object[]{source.getClass().getName()}));
                }
                if (isUsingCache.booleanValue()) {
                    this.filler.fillContext.registerLoadedRenderer(srcKey, newRenderer);
                }
            }
        }
        net.sf.jasperreports.renderers.Renderable crtRenderer = this.getRenderable();
        this.oldRenderer = this.renderer;
        this.renderer = newRenderer;
        this.prevSource = source;
        this.prevRenderer = this.renderer;
        this.setValueRepeating(crtRenderer == newRenderer);
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkWhen = (Boolean)this.evaluateExpression(this.getHyperlinkWhenExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters((JRHyperlink)this, (JRFillExpressionEvaluator)this.expressionEvaluator, (byte)evaluation);
    }

    public void rewind() {
        super.rewind();
        boolean isLegacyBandEvaluationEnabled = this.filler.getFillContext().isLegacyBandEvaluationEnabled();
        if (!isLegacyBandEvaluationEnabled) {
            this.renderer = this.oldRenderer;
        }
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderable() == null) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableHeight < this.getRelativeY() + this.getHeight()) {
                    isToPrint = false;
                    willOverflow = true;
                } else if (!(this.isLazy() || this.getScaleImageValue() != ScaleImageEnum.REAL_HEIGHT && this.getScaleImageValue() != ScaleImageEnum.REAL_SIZE)) {
                    RenderersCache renderersCache;
                    DimensionRenderable dimensionRenderer;
                    boolean imageOverflowAllowed;
                    int padding = this.getLineBox().getBottomPadding() + this.getLineBox().getTopPadding();
                    boolean reprinted = isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues());
                    boolean bl = imageOverflowAllowed = this.filler.isBandOverFlowAllowed() && !reprinted && !this.hasOverflowed;
                    if (this.renderer != null && (dimensionRenderer = (renderersCache = this.usedCache ? this.filler.fillContext.getRenderersCache() : new RenderersCache(this.filler.getJasperReportsContext())).getDimensionRenderable(this.renderer)) != null) {
                        try {
                            dimensionRenderer.getDimension(this.filler.getJasperReportsContext());
                        }
                        catch (Exception e) {
                            this.renderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).handleImageError(e, this.getOnErrorTypeValue());
                            if (this.renderer instanceof ResourceRenderer) {
                                this.renderer = renderersCache.getLoadedRenderer((ResourceRenderer)this.renderer);
                            }
                            dimensionRenderer = renderersCache.getDimensionRenderable(this.renderer);
                        }
                        if (dimensionRenderer == null) {
                            isToPrint = !this.isRemoveLineWhenBlank();
                        } else {
                            boolean fits = true;
                            Dimension2D imageSize = dimensionRenderer.getDimension(this.filler.getJasperReportsContext());
                            if (imageSize != null) {
                                fits = this.fitImage(imageSize, availableHeight - this.getRelativeY() - padding, imageOverflowAllowed, this.getHorizontalImageAlign(), this.getVerticalImageAlign());
                            }
                            if (fits) {
                                if (this.imageHeight != null) {
                                    this.setPrepareHeight(this.imageHeight + padding);
                                }
                            } else {
                                this.hasOverflowed = true;
                                isToPrint = false;
                                willOverflow = true;
                                this.setPrepareHeight(availableHeight - this.getRelativeY() - padding);
                            }
                        }
                    }
                }
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected void reset() {
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        super.reset();
    }

    protected boolean fitImage(Dimension2D imageSize, int availableHeight, boolean overflowAllowed, HorizontalImageAlignEnum hAlign, VerticalImageAlignEnum vAlign) throws JRException {
        boolean fitted;
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        int realHeight = (int)imageSize.getHeight();
        int realWidth = (int)imageSize.getWidth();
        if (this.getRotation() == RotationEnum.LEFT || this.getRotation() == RotationEnum.RIGHT) {
            int t = realWidth;
            realWidth = realHeight;
            realHeight = t;
        }
        int reducedHeight = realHeight;
        int reducedWidth = realWidth;
        if (realWidth > this.getWidth()) {
            double wRatio = (double)this.getWidth() / (double)realWidth;
            reducedHeight = (int)(wRatio * (double)realHeight);
            reducedWidth = this.getWidth();
        }
        if (reducedHeight <= availableHeight) {
            this.imageHeight = reducedHeight;
            if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
                this.imageWidth = reducedWidth;
            }
            fitted = true;
        } else if (overflowAllowed) {
            fitted = false;
        } else {
            this.imageHeight = availableHeight;
            if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
                double hRatio = (double)availableHeight / (double)realHeight;
                this.imageWidth = (int)(hRatio * (double)realWidth);
            }
            fitted = true;
        }
        if (this.imageWidth != null && this.imageWidth.intValue() != this.getWidth()) {
            block0 : switch (this.getRotation()) {
                case LEFT: {
                    switch (vAlign) {
                        case BOTTOM: 
                        case MIDDLE: {
                            this.imageX = this.getX() + (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this) * (float)(this.getWidth() - this.imageWidth));
                            break block0;
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (vAlign) {
                        case MIDDLE: 
                        case TOP: {
                            this.imageX = this.getX() + (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this)) * (float)(this.getWidth() - this.imageWidth));
                            break block0;
                        }
                    }
                    break;
                }
                case UPSIDE_DOWN: {
                    switch (hAlign) {
                        case LEFT: 
                        case CENTER: {
                            this.imageX = this.getX() + this.getWidth() - this.imageWidth - (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this) * (float)(this.getWidth() - this.imageWidth));
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    switch (hAlign) {
                        case CENTER: 
                        case RIGHT: {
                            this.imageX = this.getX() + (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this) * (float)(this.getWidth() - this.imageWidth));
                            break block0;
                        }
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fitted image of dimension " + imageSize + " on " + availableHeight + ", overflow allowed " + overflowAllowed + ": " + fitted));
        }
        return fitted;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage;
        JRRecordedValuesPrintImage recordedValuesImage;
        EvaluationTimeEnum evaluationTime = this.getEvaluationTimeValue();
        if (this.isEvaluateAuto()) {
            recordedValuesImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage(), this.printElementOriginator);
            printImage = recordedValuesImage;
        } else {
            printImage = new JRTemplatePrintImage(this.getJRTemplateImage(), this.printElementOriginator);
            recordedValuesImage = null;
        }
        printImage.setUUID(this.getUUID());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        if (this.isEvaluateNow()) {
            this.copy((JRPrintImage)printImage);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint((JRRecordedValuesPrintElement)recordedValuesImage);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printImage, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setUUID(this.getUUID());
        if (this.imageX != null) {
            printImage.setX(this.imageX.intValue());
        }
        if (this.imageWidth != null) {
            printImage.setWidth(this.imageWidth.intValue());
        }
        printImage.setRenderer(this.getRenderable());
        printImage.setAnchorName(this.getAnchorName());
        if (this.getHyperlinkWhenExpression() == null || Boolean.TRUE.equals(this.hyperlinkWhen)) {
            printImage.setHyperlinkReference(this.getHyperlinkReference());
            printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
            printImage.setHyperlinkPage(this.getHyperlinkPage());
            printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
            printImage.setHyperlinkParameters(this.hyperlinkParameters);
        } else {
            if (printImage instanceof JRTemplatePrintImage) {
                ((JRTemplatePrintImage)printImage).setHyperlinkOmitted(true);
            }
            printImage.setHyperlinkReference(null);
        }
        this.transferProperties((JRPrintElement)printImage);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRImage)this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitImage((JRImage)this);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        RenderersCache renderersCache;
        DimensionRenderable dimensionRenderer;
        this.evaluateImage(evaluation);
        JRPrintImage printImage = (JRPrintImage)element;
        if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE && (dimensionRenderer = (renderersCache = this.usedCache ? this.filler.fillContext.getRenderersCache() : new RenderersCache(this.filler.getJasperReportsContext())).getDimensionRenderable(this.renderer)) != null) {
            Dimension2D imageSize;
            try {
                dimensionRenderer.getDimension(this.filler.getJasperReportsContext());
            }
            catch (Exception e) {
                this.renderer = RendererUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).handleImageError(e, this.getOnErrorTypeValue());
                if (this.renderer instanceof ResourceRenderer) {
                    this.renderer = renderersCache.getLoadedRenderer((ResourceRenderer)this.renderer);
                }
                dimensionRenderer = renderersCache.getDimensionRenderable(this.renderer);
            }
            if (dimensionRenderer != null && (imageSize = dimensionRenderer.getDimension(this.filler.getJasperReportsContext())) != null) {
                int padding = printImage.getLineBox().getBottomPadding() + printImage.getLineBox().getTopPadding();
                this.fitImage(imageSize, this.getHeight() - padding, false, printImage.getHorizontalImageAlign(), printImage.getVerticalImageAlign());
            }
        }
        this.copy(printImage);
        this.filler.updateBookmark(element);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel == null ? ((JRImage)this.parent).getBookmarkLevel() : this.bookmarkLevel.intValue();
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillImage(this, factory);
    }

    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkWhenExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

