/*
 * Decompiled with CFR 0.152.
 */
package com.ittx.cbt.print.client.verticles.report.components;

import com.ittx.cbt.print.client.components.Generators;
import com.ittx.cbt.print.client.components.StaticCache;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/ittx/cbt/print/client/verticles/report/components/FileUtils;", "", "()V", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "jrprintSuffix", "", "pdfSuffix", "timeFormatter", "getTimeFormatter", "clean", "", "days", "", "getDir", "Ljava/nio/file/Path;", "tmpFile", "fileName", "suffix", "tmpJrprintFile", "tmpPdfFile", "print-client"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    public static final String jrprintSuffix = ".jrprint";
    @NotNull
    public static final String pdfSuffix = ".pdf";
    @NotNull
    private static final DateTimeFormatter dateFormatter;
    @NotNull
    private static final DateTimeFormatter timeFormatter;

    private FileUtils() {
    }

    @NotNull
    public final DateTimeFormatter getDateFormatter() {
        return dateFormatter;
    }

    @NotNull
    public final DateTimeFormatter getTimeFormatter() {
        return timeFormatter;
    }

    public final void clean(long days) {
        LocalDate date = LocalDate.now().minusDays(days);
        File tmpDir = Paths.get(StaticCache.INSTANCE.getTmpDir(), new String[0]).toFile();
        if (tmpDir.isDirectory()) {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)tmpDir, null, (int)1, null).maxDepth(1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                if (!file.isDirectory()) continue;
                try {
                    LocalDate dirDate = LocalDate.from(INSTANCE.getDateFormatter().parse(file.getName()));
                    if (!dirDate.isBefore(date)) continue;
                    FilesKt.deleteRecursively((File)file);
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    @NotNull
    public final Path getDir() {
        String[] stringArray = new String[]{LocalDate.now().format(dateFormatter)};
        Path datePath = Paths.get(StaticCache.INSTANCE.getTmpDir(), stringArray);
        if (Files.notExists(datePath, new LinkOption[0])) {
            Files.createDirectories(datePath, new FileAttribute[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)datePath, (String)"datePath");
        return datePath;
    }

    @NotNull
    public final Path tmpJrprintFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.tmpFile(fileName, jrprintSuffix);
    }

    @NotNull
    public final Path tmpPdfFile() {
        String fileName = String.valueOf(Generators.INSTANCE.getSnowFlake().nextId());
        return this.tmpPdfFile(LocalTime.now().format(timeFormatter) + fileName);
    }

    @NotNull
    public final Path tmpPdfFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.tmpFile(fileName, pdfSuffix);
    }

    @NotNull
    public final Path tmpFile(@NotNull String fileName, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String[] stringArray = new String[]{fileName + suffix};
        Path path = Paths.get(((Object)this.getDir().toAbsolutePath()).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(getDir().toAbsoluteP\u2026, \"${fileName}${suffix}\")");
        return path;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy_MM_dd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy_MM_dd\")");
        dateFormatter = dateTimeFormatter;
        dateTimeFormatter = DateTimeFormatter.ofPattern("HH_mm_ss_");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"HH_mm_ss_\")");
        timeFormatter = dateTimeFormatter;
    }
}

