/*
 * Decompiled with CFR 0.152.
 */
package com.ittx.cbt.print.client.util.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/ittx/cbt/print/client/util/jackson/DateSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/util/Date;", "()V", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "getTimeFormatter", "()Ljava/time/format/DateTimeFormatter;", "serialize", "", "date", "jgen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "Companion", "print-client"})
public final class DateSerializer
extends JsonSerializer<Date> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DateTimeFormatter timeFormatter;
    @NotNull
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public DateSerializer() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy-MM-dd hh:mm:ss\")");
        this.timeFormatter = dateTimeFormatter;
    }

    @NotNull
    public final DateTimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    public void serialize(@Nullable Date date, @NotNull JsonGenerator jgen, @NotNull SerializerProvider provider) throws IOException, JsonProcessingException {
        Intrinsics.checkNotNullParameter((Object)jgen, (String)"jgen");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        String formattedDate = dateFormat.format(date);
        jgen.writeString(formattedDate);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ittx/cbt/print/client/util/jackson/DateSerializer$Companion;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "print-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

