/*
 * Decompiled with CFR 0.152.
 */
package com.ittx.cbt.print.client.logger;

import com.ittx.cbt.print.client.domain.SimpleQueryOrder;
import com.ittx.cbt.print.client.logger.Tracer;
import com.ittx.cbt.print.client.util.jdbc.JdbcTemplate;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.RowSet;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J*\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u001b\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/ittx/cbt/print/client/logger/TraceLogger;", "", "detailStructure", "", "getDetailStructure", "()Ljava/lang/String;", "detailTable", "getDetailTable", "headerStructure", "getHeaderStructure", "headerTable", "getHeaderTable", "clean", "", "days", "", "findDetails", "Lio/vertx/core/Future;", "Lio/vertx/sqlclient/RowSet;", "Lio/vertx/core/json/JsonObject;", "headerId", "findHeader", "id", "findHeaders", "limit", "Lkotlin/Pair;", "", "resultFormat", "jo", "traceHeaderBeg", "Lcom/ittx/cbt/print/client/logger/Tracer;", "description", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "print-client"})
public interface TraceLogger {
    @NotNull
    public String getHeaderTable();

    @NotNull
    public String getHeaderStructure();

    @NotNull
    public String getDetailTable();

    @NotNull
    public String getDetailStructure();

    @NotNull
    public Future<RowSet<JsonObject>> findHeaders(@NotNull Pair<Integer, Integer> var1);

    public void resultFormat(@NotNull JsonObject var1);

    @NotNull
    public Future<RowSet<JsonObject>> findHeader(long var1);

    @NotNull
    public Future<RowSet<JsonObject>> findDetails(long var1);

    public void clean(long var1);

    @Nullable
    public Object traceHeaderBeg(@NotNull String var1, @NotNull Continuation<? super Tracer> var2);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String getDetailStructure(@NotNull TraceLogger this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "\n          \"id\" integer NOT NULL PRIMARY KEY,\n          \"headerId\" integer NOT NULL,\n          \"batchId\" text DEFAULT \"\",\n          \"input\" text DEFAULT \"\",\n          \"output\" text DEFAULT \"\",\n          \"description\" text DEFAULT \"\",\n          \"status\" text DEFAULT \"\",\n          \"begAt\" datetime DEFAULT NULL,\n          \"endAt\" datetime DEFAULT NULL\n      ";
        }

        @NotNull
        public static Future<RowSet<JsonObject>> findHeaders(@NotNull TraceLogger this_, @NotNull Pair<Integer, Integer> limit) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(limit, (String)"limit");
            List orders = CollectionsKt.listOf((Object)new SimpleQueryOrder("begAt", null, 2, null));
            boolean bl = false;
            bl = false;
            Future future = JdbcTemplate.INSTANCE.simpleQuery(this_.getHeaderTable(), MapsKt.emptyMap(), CollectionsKt.emptyList(), orders, limit).map(arg_0 -> DefaultImpls.findHeaders$lambda-0(this_, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"JdbcTemplate.simpleQuery\u2026ultFormat)\n      rs\n    }");
            return future;
        }

        public static /* synthetic */ Future findHeaders$default(TraceLogger traceLogger, Pair pair, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findHeaders");
            }
            if ((n & 1) != 0) {
                pair = TuplesKt.to((Object)0, (Object)100);
            }
            return traceLogger.findHeaders((Pair<Integer, Integer>)pair);
        }

        public static void resultFormat(@NotNull TraceLogger this_, @NotNull JsonObject jo) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jo, (String)"jo");
            String id = jo.getString("id");
            jo.put("id", (Object)id);
            CharSequence charSequence2 = jo.getString("begAt");
            String begAt = charSequence2 == null ? "" : charSequence2;
            charSequence2 = begAt;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                jo.put("begAt", (Object)LocalDateTime.parse(begAt));
            }
            String endAt = (charSequence = jo.getString("endAt")) == null ? "" : charSequence;
            charSequence = endAt;
            boolean bl2 = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                jo.put("endAt", (Object)LocalDateTime.parse(endAt));
            }
        }

        @NotNull
        public static Future<RowSet<JsonObject>> findHeader(@NotNull TraceLogger this_, long id) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JdbcTemplate.findById$default(JdbcTemplate.INSTANCE, this_.getHeaderTable(), id, null, null, 12, null);
        }

        @NotNull
        public static Future<RowSet<JsonObject>> findDetails(@NotNull TraceLogger this_, long headerId) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"headerId", (Object)headerId)};
            Future future = JdbcTemplate.INSTANCE.simpleQuery(this_.getDetailTable(), pairArray).map(arg_0 -> DefaultImpls.findDetails$lambda-2(this_, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"JdbcTemplate.simpleQuery\u2026ultFormat)\n      rs\n    }");
            return future;
        }

        public static void clean(@NotNull TraceLogger this_, long days) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JdbcTemplate jdbcTemplate = JdbcTemplate.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            JdbcTemplate $this$clean_u24lambda_u2d5 = jdbcTemplate;
            boolean bl3 = false;
            String sql2 = "select id from " + this_.getHeaderTable() + " where begAt < #{begAt}";
            String headerDeleteSql = "delete from " + this_.getHeaderTable() + " where id = #{id}";
            String detailDeleteSql = "delete from " + this_.getHeaderTable() + " where headerId = #{headerId}";
            LocalDateTime begAt = LocalDateTime.now().minusDays(days);
            $this$clean_u24lambda_u2d5.query(sql2).execute((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"begAt", (Object)begAt))).onSuccess(arg_0 -> DefaultImpls.clean$lambda-5$lambda-4($this$clean_u24lambda_u2d5, headerDeleteSql, detailDeleteSql, arg_0));
        }

        @Nullable
        public static Object traceHeaderBeg(@NotNull TraceLogger this_, @NotNull String description, @NotNull Continuation<? super Tracer> $completion) {
            return new Tracer(this_.getHeaderTable(), this_.getDetailTable(), 0L, 4, null);
        }

        public static /* synthetic */ Object traceHeaderBeg$default(TraceLogger traceLogger, String string, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: traceHeaderBeg");
            }
            if ((n & 1) != 0) {
                string = "";
            }
            return traceLogger.traceHeaderBeg(string, (Continuation<? super Tracer>)continuation);
        }

        private static final RowSet findHeaders$lambda-0(TraceLogger this$0, RowSet rs) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
            Iterable $this$forEach$iv = (Iterable)rs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject p0 = (JsonObject)element$iv;
                boolean bl = false;
                this$0.resultFormat(p0);
            }
            return rs;
        }

        private static final RowSet findDetails$lambda-2(TraceLogger this$0, RowSet rs) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
            Iterable $this$forEach$iv = (Iterable)rs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject p0 = (JsonObject)element$iv;
                boolean bl = false;
                this$0.resultFormat(p0);
            }
            return rs;
        }

        private static final void clean$lambda-5$lambda-4(JdbcTemplate $this_run, String $headerDeleteSql, String $detailDeleteSql, RowSet rs) {
            Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
            Intrinsics.checkNotNullParameter((Object)$headerDeleteSql, (String)"$headerDeleteSql");
            Intrinsics.checkNotNullParameter((Object)$detailDeleteSql, (String)"$detailDeleteSql");
            Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
            Iterable $this$forEach$iv = (Iterable)rs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject jo = (JsonObject)element$iv;
                boolean bl = false;
                Long id = jo.getLong("id");
                $this_run.update($headerDeleteSql).execute((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)id)));
                $this_run.update($detailDeleteSql).execute((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"headerId", (Object)id)));
            }
        }
    }
}

