/*
 * Decompiled with CFR 0.152.
 */
package com.ittx.cbt.print.client.dao;

import com.ittx.cbt.print.client.components.LoggingAround;
import com.ittx.cbt.print.client.components.StaticCache;
import com.ittx.cbt.print.client.dao.IDao;
import com.ittx.cbt.print.client.domain.JasperPrinterConfig;
import com.ittx.cbt.print.client.util.jdbc.JdbcTemplate;
import com.ittx.cbt.print.client.verticles.report.components.PrinterUtils;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\r\u001a\u00020\u0005J\u0014\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\"\u0010\u0019\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/ittx/cbt/print/client/dao/JasperPrinterConfigDao;", "Lcom/ittx/cbt/print/client/components/LoggingAround;", "Lcom/ittx/cbt/print/client/dao/IDao;", "()V", "idColumnName", "", "structure", "getStructure", "()Ljava/lang/String;", "tableName", "getTableName", "addToCache", "", "code", "printer", "clearCache", "getJasperPrinterList", "Lio/vertx/core/Future;", "Lio/vertx/sqlclient/RowSet;", "Lio/vertx/core/json/JsonObject;", "getPrinterByCode", "saveJasperPrinterConfig", "configs", "", "Lcom/ittx/cbt/print/client/domain/JasperPrinterConfig;", "syncJasperPrinterConfig", "onComplete", "Lkotlin/Function0;", "print-client"})
public final class JasperPrinterConfigDao
implements LoggingAround,
IDao {
    @NotNull
    public static final JasperPrinterConfigDao INSTANCE = new JasperPrinterConfigDao();
    @NotNull
    private static final String tableName = "jasper_printer_config";
    @NotNull
    private static final String structure = "\n        \"code\" text NOT NULL PRIMARY KEY,\n        \"type\" text DEFAULT NULL,\n        \"printer\" text DEFAULT NULL,\n        \"version\" integer DEFAULT NULL,\n        \"savedDate\" datetime DEFAULT NULL\n    ";
    @NotNull
    public static final String idColumnName = "code";

    private JasperPrinterConfigDao() {
    }

    @Override
    @NotNull
    public String getTableName() {
        return tableName;
    }

    @Override
    @NotNull
    public String getStructure() {
        return structure;
    }

    public final void addToCache(@NotNull String code, @NotNull String printer) {
        Intrinsics.checkNotNullParameter((Object)code, (String)idColumnName);
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Map<String, String> map2 = StaticCache.INSTANCE.getJasperPrinterConfigCache();
        boolean bl = false;
        map2.put(code, printer);
    }

    public final void clearCache() {
        StaticCache.INSTANCE.getJasperPrinterConfigCache().clear();
    }

    @NotNull
    public final Future<String> getPrinterByCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)idColumnName);
        Future future = Future.future(arg_0 -> JasperPrinterConfigDao.getPrinterByCode$lambda-3(code, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future { it ->\n      it.\u2026}\n        }\n      }\n    }");
        return future;
    }

    @NotNull
    public final Future<RowSet<JsonObject>> getJasperPrinterList() {
        this.clearCache();
        Future future = JdbcTemplate.INSTANCE.simpleQuery(this.getTableName(), new Pair[0]).onSuccess(JasperPrinterConfigDao::getJasperPrinterList$lambda-5);
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"JdbcTemplate.simpleQuery\u2026)\n        }\n      }\n    }");
        return future;
    }

    public final void saveJasperPrinterConfig(@NotNull List<JasperPrinterConfig> configs2) {
        Intrinsics.checkNotNullParameter(configs2, (String)"configs");
        this.clearCache();
        Iterable $this$forEach$iv = configs2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JasperPrinterConfig config = (JasperPrinterConfig)element$iv;
            boolean bl = false;
            Object object = config.getPrinter();
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)object))) continue;
            String string = INSTANCE.getTableName();
            object = JsonObject.mapFrom((Object)config).getMap();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapFrom(config).map");
            JdbcTemplate.INSTANCE.update(string, (Map<String, ? extends Object>)object, config.getCode(), idColumnName);
            INSTANCE.addToCache(config.getCode(), config.getPrinter());
        }
    }

    public final void syncJasperPrinterConfig(@NotNull List<JasperPrinterConfig> configs2, @NotNull Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter(configs2, (String)"configs");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        StaticCache.INSTANCE.getJasperPrinterConfigCache().clear();
        JdbcTemplate jdbcTemplate = JdbcTemplate.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JdbcTemplate $this$syncJasperPrinterConfig_u24lambda_u2d12 = jdbcTemplate;
        boolean bl3 = false;
        $this$syncJasperPrinterConfig_u24lambda_u2d12.simpleQuery(INSTANCE.getTableName(), new Pair[0]).onSuccess(arg_0 -> JasperPrinterConfigDao.syncJasperPrinterConfig$lambda-12$lambda-11(configs2, $this$syncJasperPrinterConfig_u24lambda_u2d12, onComplete, arg_0));
    }

    @Override
    public <T> T logInfo(@NotNull String msg, @NotNull Function0<? extends T> body) {
        return LoggingAround.DefaultImpls.logInfo(this, msg, body);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return LoggingAround.DefaultImpls.getLogger(this);
    }

    private static final void getPrinterByCode$lambda-3$lambda-2$lambda-0(Promise $this_run, String $code, RowSet it) {
        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
        $this_run.complete((Object)StaticCache.INSTANCE.getJasperPrinterConfigCache().get($code));
    }

    private static final void getPrinterByCode$lambda-3$lambda-2$lambda-1(Promise $this_run, Throwable e) {
        $this_run.fail(e);
    }

    private static final void getPrinterByCode$lambda-3(String $code, Promise it) {
        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
        Promise promise = it;
        boolean bl = false;
        boolean bl2 = false;
        Promise $this$getPrinterByCode_u24lambda_u2d3_u24lambda_u2d2 = promise;
        boolean bl3 = false;
        if (StaticCache.INSTANCE.getJasperPrinterConfigCache().containsKey($code)) {
            $this$getPrinterByCode_u24lambda_u2d3_u24lambda_u2d2.complete((Object)StaticCache.INSTANCE.getJasperPrinterConfigCache().get($code));
        } else {
            INSTANCE.getJasperPrinterList().onSuccess(arg_0 -> JasperPrinterConfigDao.getPrinterByCode$lambda-3$lambda-2$lambda-0($this$getPrinterByCode_u24lambda_u2d3_u24lambda_u2d2, $code, arg_0)).onFailure(arg_0 -> JasperPrinterConfigDao.getPrinterByCode$lambda-3$lambda-2$lambda-1($this$getPrinterByCode_u24lambda_u2d3_u24lambda_u2d2, arg_0));
        }
    }

    private static final void getJasperPrinterList$lambda-5(RowSet rs) {
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        Iterable $this$forEach$iv = (Iterable)rs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonObject jo = (JsonObject)element$iv;
            boolean bl = false;
            if (!jo.containsKey(idColumnName) || !jo.containsKey("printer")) continue;
            String string = jo.getString(idColumnName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jo.getString(\"code\")");
            String string2 = string;
            string = jo.getString("printer");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jo.getString(\"printer\")");
            INSTANCE.addToCache(string2, string);
        }
    }

    private static final void syncJasperPrinterConfig$lambda-12$lambda-11$lambda-10$lambda-9(Function0 $onComplete, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
        $onComplete.invoke();
    }

    private static final void syncJasperPrinterConfig$lambda-12$lambda-11$lambda-10(JdbcTemplate $this_run, List $codes, Function0 $onComplete, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)$codes, (String)"$codes");
        Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
        $this_run.deleteNotIn(INSTANCE.getTableName(), $codes, idColumnName).onComplete(arg_0 -> JasperPrinterConfigDao.syncJasperPrinterConfig$lambda-12$lambda-11$lambda-10$lambda-9($onComplete, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void syncJasperPrinterConfig$lambda-12$lambda-11(List $configs, JdbcTemplate $this_run, Function0 $onComplete, RowSet list) {
        void $this$mapTo$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$configs, (String)"$configs");
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
        Iterable $this$groupBy$iv = (Iterable)list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            JsonObject it = (JsonObject)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getString(idColumnName);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map2 = destination$iv$iv;
        $i$f$groupBy = false;
        List futures = new ArrayList();
        Iterable $this$map$iv = $configs;
        boolean $i$f$map = false;
        Iterable $i$f$groupByTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Future<SqlResult<Void>> future;
            void config;
            key$iv$iv = (JasperPrinterConfig)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Object object = map2;
            String string = config.getCode();
            boolean bl3 = false;
            Map map3 = object;
            boolean bl4 = false;
            if (map3.containsKey(string)) {
                Object v = map2.get(config.getCode());
                Intrinsics.checkNotNull(v);
                object = ((JsonObject)CollectionsKt.first((List)((List)v))).getString("printer");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map[config.code]!!.first().getString(\"printer\")");
                config.setPrinter((String)object);
                String string2 = INSTANCE.getTableName();
                object = JsonObject.mapFrom((Object)config).getMap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapFrom(config).map");
                future = $this_run.update(string2, (Map<String, ? extends Object>)object, config.getCode(), idColumnName);
            } else {
                config.setPrinter(PrinterUtils.INSTANCE.findDefaultPrinterName());
                String string3 = INSTANCE.getTableName();
                object = JsonObject.mapFrom((Object)config).getMap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapFrom(config).map");
                future = $this_run.insert(string3, (Map<String, ? extends Object>)object);
            }
            futures.add(future);
            String string4 = config.getCode();
            collection.add(string4);
        }
        List codes = (List)destination$iv$iv2;
        CompositeFuture.join((List)CollectionsKt.toList((Iterable)futures)).onComplete(arg_0 -> JasperPrinterConfigDao.syncJasperPrinterConfig$lambda-12$lambda-11$lambda-10($this_run, codes, $onComplete, arg_0));
    }
}

