/*
 * Decompiled with CFR 0.152.
 */
package com.ittx.cbt.print.client.components;

import com.ittx.cbt.print.client.dao.CloudPrintDao;
import com.ittx.cbt.print.client.dao.DebugDao;
import com.ittx.cbt.print.client.dao.DefaultDao;
import com.ittx.cbt.print.client.dao.IDao;
import com.ittx.cbt.print.client.dao.JasperPrinterConfigDao;
import com.ittx.cbt.print.client.dao.JasperServerConfigDao;
import com.ittx.cbt.print.client.dao.JasperVersionDao;
import com.ittx.cbt.print.client.logger.CloudPrintTraceLogger;
import com.ittx.cbt.print.client.logger.JasperTraceLogger;
import com.ittx.cbt.print.client.logger.TraceLogger;
import com.ittx.cbt.print.client.util.jdbc.JdbcTemplate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ittx/cbt/print/client/components/TableInitialization;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "drop", "", "execute", "", "initDaoTable", "dao", "Lcom/ittx/cbt/print/client/dao/IDao;", "initOrDrop", "initTraceLoggerTable", "qtl", "Lcom/ittx/cbt/print/client/logger/TraceLogger;", "print-client"})
public final class TableInitialization
implements Logging {
    @NotNull
    public static final TableInitialization INSTANCE = new TableInitialization();
    private static final boolean drop = false;

    private TableInitialization() {
    }

    public final void execute() {
        this.initDaoTable(DefaultDao.INSTANCE);
        this.initDaoTable(JasperServerConfigDao.INSTANCE);
        this.initDaoTable(JasperPrinterConfigDao.INSTANCE);
        this.initDaoTable(CloudPrintDao.INSTANCE);
        this.initOrDrop(DebugDao.INSTANCE);
        this.initTraceLoggerTable(CloudPrintTraceLogger.INSTANCE);
        this.initTraceLoggerTable(JasperTraceLogger.INSTANCE);
        this.initDaoTable(JasperVersionDao.INSTANCE);
    }

    public final void initDaoTable(@NotNull IDao dao) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        JdbcTemplate.INSTANCE.init(dao.getTableName(), dao.getStructure(), false);
    }

    public final void initOrDrop(@NotNull IDao dao) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        JdbcTemplate.INSTANCE.init(dao.getTableName(), dao.getStructure(), true);
    }

    public final void initTraceLoggerTable(@NotNull TraceLogger qtl) {
        Intrinsics.checkNotNullParameter((Object)qtl, (String)"qtl");
        JdbcTemplate.INSTANCE.init(qtl.getHeaderTable(), qtl.getHeaderStructure(), true);
        JdbcTemplate.INSTANCE.init(qtl.getDetailTable(), qtl.getDetailStructure(), true);
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

