/*
 * Decompiled with CFR 0.152.
 */
package com.ittx.cbt.print.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ittx.cbt.print.client.components.Cleaner;
import com.ittx.cbt.print.client.components.ConsumersInitialization;
import com.ittx.cbt.print.client.components.LoggingCoroutineVerticle;
import com.ittx.cbt.print.client.components.StaticCache;
import com.ittx.cbt.print.client.components.TableInitialization;
import com.ittx.cbt.print.client.components.WebClients;
import com.ittx.cbt.print.client.dao.JasperPrinterConfigDao;
import com.ittx.cbt.print.client.util.jackson.JSR310Module;
import com.ittx.cbt.print.client.util.jdbc.JdbcTemplate;
import com.ittx.cbt.print.client.util.jdbc.Sqlite;
import com.ittx.cbt.print.client.verticles.TrayVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\u0014\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010J\u0011\u0010\u0011\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcom/ittx/cbt/print/client/MainVerticle;", "Lcom/ittx/cbt/print/client/components/LoggingCoroutineVerticle;", "()V", "verticleName", "", "getVerticleName", "()Ljava/lang/String;", "initJacksonMapper", "", "initJdbc", "initTable", "initTray", "initWebClient", "makeFlag", "reloadJasperReportFiles", "message", "Lio/vertx/core/eventbus/Message;", "startProcess", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopProcess", "Companion", "print-client"})
public final class MainVerticle
extends LoggingCoroutineVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DB_NAME = "pdb.db";
    @NotNull
    private static final String FLAG_NAME = "(\uff61\u1edb\u2083\u1edd)\u06be.f";

    @Override
    @NotNull
    public String getVerticleName() {
        return "Print Client";
    }

    @Override
    @Nullable
    public Object startProcess(@NotNull Continuation<? super Unit> $completion) {
        this.makeFlag();
        this.initTray();
        this.initJdbc();
        this.initTable();
        this.initWebClient();
        this.initJacksonMapper();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Cleaner.INSTANCE.clean();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        EventBus eventBus = this.getVertx().eventBus();
        MessageConsumer messageConsumer = eventBus.consumer("jasperReportFileReload", this::reloadJasperReportFiles);
        if (messageConsumer == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return messageConsumer;
        }
        return Unit.INSTANCE;
    }

    private final void makeFlag() {
        File f = new File(new File("").getAbsolutePath() + File.separator + FLAG_NAME);
        if (f.exists()) {
            return;
        }
        f.createNewFile();
    }

    private final void initTray() {
        DeploymentOptions options = new DeploymentOptions();
        options.setWorker(true);
        this.getVertx().deployVerticle((Verticle)new TrayVerticle(), options).onFailure(MainVerticle::initTray$lambda-0);
    }

    private final void initJdbc() {
        this.logInfo("Jdbc Initialization", (Function0)new Function0<Unit>(this){
            final /* synthetic */ MainVerticle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                JdbcTemplate.INSTANCE.setWritePool(Sqlite.configPool$default(Sqlite.INSTANCE, this.this$0.getVertx(), MainVerticle.Companion.getDB_NAME(), 1, false, 8, null));
                JdbcTemplate.INSTANCE.setReadPool(Sqlite.configPool$default(Sqlite.INSTANCE, this.this$0.getVertx(), MainVerticle.Companion.getDB_NAME(), 10, false, 8, null));
            }
        });
    }

    private final void initTable() {
        this.logInfo("init table", (Function0)new Function0<Unit>(this){
            final /* synthetic */ MainVerticle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TableInitialization.INSTANCE.execute();
                new ConsumersInitialization(this.this$0.getVertx()).execute();
            }
        });
    }

    private final void initWebClient() {
        this.logInfo("init web client", (Function0)new Function0<Unit>(this){
            final /* synthetic */ MainVerticle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WebClientOptions webClientOptions = new WebClientOptions();
                webClientOptions.setKeepAlive(false);
                WebClient webClient = WebClient.create((Vertx)this.this$0.getVertx(), (WebClientOptions)webClientOptions);
                Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"create(vertx, webClientOptions)");
                WebClients.INSTANCE.setClient(webClient);
                WebClientOptions noSSLWebClientOptions = new WebClientOptions();
                noSSLWebClientOptions.setTrustAll(true);
                noSSLWebClientOptions.setKeepAlive(false);
                noSSLWebClientOptions.setSsl(true);
                noSSLWebClientOptions.setVerifyHost(false);
                WebClient webClient2 = WebClient.create((Vertx)this.this$0.getVertx(), (WebClientOptions)noSSLWebClientOptions);
                Intrinsics.checkNotNullExpressionValue((Object)webClient2, (String)"create(vertx, noSSLWebClientOptions)");
                WebClients.INSTANCE.setNoSSLClient(webClient2);
            }
        });
    }

    private final void initJacksonMapper() {
        ObjectMapper mapper = DatabindCodec.mapper();
        mapper.registerModule((Module)new JSR310Module());
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd hh:MM:ss"));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
        mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        mapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public final void reloadJasperReportFiles(@NotNull Message<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        String jo = (String)message.body();
        Map<String, Object> map2 = StaticCache.INSTANCE.getEventCache();
        boolean bl = false;
        Map<String, Object> map3 = map2;
        boolean bl2 = false;
        if (map3.containsKey(jo)) {
            Object object = StaticCache.INSTANCE.getEventCache().remove(jo);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.ittx.cbt.print.client.domain.JasperPrinterConfig>");
            }
            List configs2 = (List)object;
            JasperPrinterConfigDao.INSTANCE.syncJasperPrinterConfig(configs2, (Function0<Unit>)((Function0)new Function0<Unit>(message){
                final /* synthetic */ Message<String> $message;
                {
                    this.$message = $message;
                    super(0);
                }

                public final void invoke() {
                    this.$message.reply((Object)"");
                }
            }));
        }
    }

    @Override
    @Nullable
    public Object stopProcess(@NotNull Continuation<? super Unit> $completion) {
        JdbcTemplate.INSTANCE.getWritePool().close();
        Future future = JdbcTemplate.INSTANCE.getReadPool().close();
        if (future == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return future;
        }
        return Unit.INSTANCE;
    }

    private static final void initTray$lambda-0(Throwable it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        throw it;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/ittx/cbt/print/client/MainVerticle$Companion;", "", "()V", "DB_NAME", "", "getDB_NAME", "()Ljava/lang/String;", "FLAG_NAME", "getFLAG_NAME", "print-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDB_NAME() {
            return DB_NAME;
        }

        @NotNull
        public final String getFLAG_NAME() {
            return FLAG_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

