/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.JavaVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

final class VersionCheck {
    private static final String RESOURCES_VERSION_PROPERTIES = "/resources/version.properties";
    private static final String JAVA_VERSION = "java.version";

    private VersionCheck() {
    }

    private static String getVersion() {
        String result = "";
        InputStream in = VersionCheck.class.getResourceAsStream(RESOURCES_VERSION_PROPERTIES);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String[] parts;
            String line = reader.readLine();
            if (!line.isEmpty() && (parts = line.split("=")).length == 2) {
                result = parts[1];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isSameVersion() {
        boolean result = false;
        JavaVersion jarVersion = new JavaVersion(VersionCheck.getVersion());
        JavaVersion runtimeVersion = new JavaVersion(System.getProperty(JAVA_VERSION));
        if (!jarVersion.isEmpty() && !runtimeVersion.isEmpty() && jarVersion.match(runtimeVersion)) {
            result = true;
        }
        return result;
    }
}

