/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.Application;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.types.DataType;

public class Runtime
extends DataType
implements Cloneable,
DynamicElement,
DynamicAttribute {
    private List<Argument> addModules = new LinkedList<Argument>();
    private List<Argument> limitModules = new LinkedList<Argument>();
    private List<Argument> modulePath = new LinkedList<Argument>();
    private Boolean stripNativeCommands;
    private Boolean detectModules;

    private List<String> processArguments(List<Argument> args, String pattern) {
        LinkedList<String> result = new LinkedList<String>();
        for (Argument a : args) {
            for (String s : a.getValue().split(pattern)) {
                result.add(s);
            }
        }
        return result;
    }

    private Argument createAddModules() {
        Argument a = new Argument();
        this.addModules.add(a);
        return a;
    }

    List<String> getAddModules() {
        return this.processArguments(this.addModules, "[,;: ]+");
    }

    private Argument createLimitModules() {
        Argument a = new Argument();
        this.limitModules.add(a);
        return a;
    }

    List<String> getLimitModules() {
        return this.processArguments(this.limitModules, "[,;: ]+");
    }

    private Argument createModulePath() {
        Argument a = new Argument();
        this.modulePath.add(a);
        return a;
    }

    public String getModulePath() {
        Object result = "";
        List<String> paths = this.processArguments(this.modulePath, "[" + File.pathSeparator + "]+");
        for (String s : paths) {
            if (!((String)result).isEmpty()) {
                result = (String)result + File.pathSeparator;
            }
            result = (String)result + s;
        }
        return result;
    }

    public Boolean getStripNativeCommands() {
        return this.stripNativeCommands;
    }

    public void setStripNativeCommands(boolean value) {
        this.stripNativeCommands = value;
    }

    public Boolean getDetectModules() {
        return this.detectModules;
    }

    public void setDetectModules(boolean value) {
        this.detectModules = value;
    }

    public Object clone() {
        try {
            Application result = (Application)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public Runtime get() {
        return this.isReference() ? (Runtime)this.getRefid().getReferencedObject() : this;
    }

    public Object createDynamicElement(String name) {
        if (name.equals("add-modules")) {
            return this.createAddModules();
        }
        if (name.equals("limit-modules")) {
            return this.createLimitModules();
        }
        if (name.equals("module-path")) {
            return this.createModulePath();
        }
        return null;
    }

    public void setDynamicAttribute(String name, String value) {
        if (name.equals("strip-native-commands")) {
            this.stripNativeCommands = Boolean.valueOf(value);
        } else if (name.equals("detect-modules")) {
            this.detectModules = Boolean.valueOf(value);
        }
    }

    public class Argument {
        private String value;

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

