/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.oracle.tools.packager.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion {
    private static final Pattern fullVersionMatcher = Pattern.compile("((\\d+).(\\d+).(\\d+).(\\d+))(-(.*))?(\\+[^\"]*)?");
    private static final Pattern shortVersionMatcher = Pattern.compile("(\\d+)(-(.*))?(\\+[^\"]*)?");
    private String release;
    private String major;
    private String minor;
    private String security;
    private String patch;
    private String modifiers;
    private boolean empty = true;

    public JavaVersion(String version) {
        if (version != null && !version.isEmpty()) {
            Matcher matcher = fullVersionMatcher.matcher(version);
            if (matcher.find()) {
                this.empty = false;
                this.release = matcher.group(1);
                this.major = matcher.group(2);
                this.minor = matcher.group(3);
                this.security = matcher.group(4);
                this.patch = matcher.group(5);
                this.modifiers = matcher.group(7);
            } else {
                matcher = shortVersionMatcher.matcher(version);
                if (matcher.find()) {
                    this.empty = false;
                    this.release = matcher.group(1);
                    this.major = matcher.group(1);
                    this.modifiers = matcher.group(3);
                } else {
                    Log.info((String)"Error: Unable to recognize java version format.");
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean match(JavaVersion other) {
        if (this.major != null && other.major != null && !this.major.equals(other.major)) {
            return false;
        }
        if (this.minor != null && other.minor != null && !this.minor.equals(other.minor)) {
            return false;
        }
        if (this.security != null && other.security != null && !this.security.equals(other.security)) {
            return false;
        }
        return this.patch == null || other.patch == null || this.patch.equals(other.patch);
    }

    public String toString() {
        return "[Release: " + this.release + "; Major: " + this.major + "; Minor: " + this.minor + "; Security: " + this.security + "; Patch: " + this.patch + "; Modifiers: " + this.modifiers + "]";
    }
}

