/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.oracle.tools.packager.Log;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.SignJarParams;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FXSignJarTask
extends Task {
    private File keyStore;
    private String alias;
    private String storePass;
    private String keyPass;
    private String storeType = "jks";
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private String deprecatedSourceJar;
    private String sourceJar;
    private String destDir;
    private PackagerLib packager;
    private SignJarParams signJarParams;
    private boolean verbose = false;

    public FXSignJarTask() {
        Log.info((String)"Warning: <fx:signjar> has been deprecated and will be removed in a future release.");
        this.packager = new PackagerLib();
        this.signJarParams = new SignJarParams();
    }

    public void execute() throws BuildException {
        File sourceFile;
        this.signJarParams.setKeyStore(this.keyStore);
        this.signJarParams.setAlias(this.alias);
        this.signJarParams.setStorePass(this.storePass);
        this.signJarParams.setKeyPass(this.keyPass);
        this.signJarParams.setStoreType(this.storeType);
        this.signJarParams.setVerbose(this.verbose);
        if (this.destDir != null) {
            this.signJarParams.setOutdir(new File(this.destDir));
        }
        if (!this.fileSets.isEmpty()) {
            if (this.deprecatedSourceJar != null) {
                throw new IllegalArgumentException("Unexpected sourcejar attribute when fileset present");
            }
            if (this.sourceJar != null) {
                throw new IllegalArgumentException("Unexpected sourcejar attribute when fileset present");
            }
        }
        if (this.sourceJar != null && this.deprecatedSourceJar != null) {
            throw new IllegalArgumentException("Cannot use both sourcejar and jar attributes. (sourcejar attribute is deprecated).");
        }
        for (FileSet fileset : this.fileSets) {
            Utils.addResources((CommonParams)this.signJarParams, fileset);
        }
        if (this.deprecatedSourceJar != null && (sourceFile = new File(this.deprecatedSourceJar)).exists()) {
            this.signJarParams.addResource(new File("."), sourceFile);
        }
        if (this.sourceJar != null && (sourceFile = new File(this.sourceJar)).exists()) {
            this.signJarParams.addResource(sourceFile.getParentFile(), sourceFile.getName());
        }
        try {
            this.signJarParams.validate();
            this.packager.signJar(this.signJarParams);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public void setKeyPass(String keyPassword) {
        this.keyPass = keyPassword;
    }

    public void setStorePass(String storePassword) {
        this.storePass = storePassword;
    }

    public void setKeyStore(File keyStore) {
        this.keyStore = keyStore;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public void addFileSet(FileSet fileset) {
        this.fileSets.add(fileset);
    }

    public void setSourceJar(String sourceJar) {
        this.deprecatedSourceJar = sourceJar;
    }

    public void setJar(String sourceJar) {
        this.sourceJar = sourceJar;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }
}

