/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.sun.javafx.tools.ant.AntLog;
import com.sun.javafx.tools.ant.Application;
import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.ant.Callbacks;
import com.sun.javafx.tools.ant.FileAssociation;
import com.sun.javafx.tools.ant.FileSet;
import com.sun.javafx.tools.ant.Info;
import com.sun.javafx.tools.ant.Permissions;
import com.sun.javafx.tools.ant.Platform;
import com.sun.javafx.tools.ant.Preferences;
import com.sun.javafx.tools.ant.Resources;
import com.sun.javafx.tools.ant.Runtime;
import com.sun.javafx.tools.ant.SecondaryLauncher;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.ant.VersionCheck;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public class DeployFXTask
extends Task
implements DynamicAttribute {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(DeployFXTask.class.getName());
    private String width = null;
    private String height = null;
    private String embeddedWidth = null;
    private String embeddedHeight = null;
    private String outfile = null;
    private String outdir = null;
    private boolean embedJNLP;
    private boolean isExtension = false;
    private Boolean signBundle;
    private boolean includeDT = false;
    private String updateMode = "background";
    private Info appInfo = null;
    private Application app = null;
    private Resources resources = null;
    private Preferences prefs = null;
    private String codebase = null;
    private String placeholder;
    private PackagerLib packager;
    private DeployParams deployParams;
    private Callbacks callbacks;
    boolean offlineAllowed = true;
    Bundler.BundleType nativeBundles = Bundler.BundleType.NONE;
    String bundleFormat = null;
    boolean versionCheck = true;
    private boolean verbose = false;
    List<Template> templateList = new LinkedList<Template>();
    Platform platform;
    private Permissions perms = null;
    List<BundleArgument> bundleArgumentList = new LinkedList<BundleArgument>();
    private List<SecondaryLauncher> secondaryLaunchers = new ArrayList<SecondaryLauncher>();
    private Runtime runtime = null;

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setCodebase(String str) {
        this.codebase = str;
    }

    public DeployFXTask() {
        this.packager = new PackagerLib();
        this.deployParams = new DeployParams();
    }

    public void execute() {
        boolean isModular = this.app.getModule() != null && !this.app.getModule().isEmpty();
        this.deployParams.setOutfile(this.outfile);
        this.deployParams.setOutdir(new File(this.outdir));
        if (this.versionCheck && !VersionCheck.isSameVersion()) {
            throw new BuildException(I18N.getString("message.java.version.mismatch"));
        }
        if (!(isModular || this.nativeBundles != Bundler.BundleType.JNLP && this.nativeBundles != Bundler.BundleType.ALL && this.nativeBundles != Bundler.BundleType.NONE)) {
            this.setAppInfo();
            this.deployParams.setOfflineAllowed(this.offlineAllowed);
            this.deployParams.setVerbose(this.verbose);
            this.deployParams.setCodebase(this.codebase);
            this.deployParams.setSignBundle(this.signBundle);
            if (this.app != null && this.app.getModule() == null) {
                this.deployParams.setApplicationClass(this.app.get().mainClass);
            }
            if (this.width != null) {
                this.deployParams.setWidth(Integer.valueOf(this.width).intValue());
            }
            if (this.height != null) {
                this.deployParams.setHeight(Integer.valueOf(this.height).intValue());
            }
            if (this.embeddedWidth != null && this.embeddedHeight != null) {
                this.deployParams.setEmbeddedDimensions(this.embeddedWidth, this.embeddedHeight);
            }
            this.deployParams.setEmbedJNLP(this.embedJNLP);
            if (this.perms != null) {
                this.deployParams.setAllPermissions(this.perms.getElevated());
            }
            this.deployParams.setUpdateMode(this.updateMode);
            this.deployParams.setExtension(this.isExtension);
            this.deployParams.setIncludeDT(this.includeDT);
            if (this.callbacks != null) {
                for (Callback callback : this.callbacks.callbacks) {
                    this.deployParams.addCallback(callback.getName(), callback.getCmd());
                }
            }
            this.setPlatform();
            this.setPreferences();
            for (Template template : this.templateList) {
                this.deployParams.addTemplate(template.infile, template.outfile);
            }
        }
        if (isModular && (this.nativeBundles == Bundler.BundleType.NATIVE || this.nativeBundles == Bundler.BundleType.IMAGE || this.nativeBundles == Bundler.BundleType.INSTALLER || this.nativeBundles == Bundler.BundleType.ALL)) {
            if (this.app != null) {
                if (this.app.getModule() == null) {
                    this.deployParams.setApplicationClass(this.app.get().mainClass);
                } else {
                    int index = this.app.getModule().indexOf("/");
                    if (index > 0) {
                        this.deployParams.setModule(this.app.getModule());
                    } else {
                        this.deployParams.setModule(this.app.getModule() + "/" + this.app.get().mainClass);
                    }
                }
                this.deployParams.setPreloader(this.app.get().preloaderClass);
                this.deployParams.setAppId(this.app.get().id);
                this.deployParams.setAppName(this.app.get().name);
                this.deployParams.setParams(this.app.get().parameters);
                this.deployParams.setArguments(this.app.get().getArguments());
                this.deployParams.setHtmlParams(this.app.get().htmlParameters);
                this.deployParams.setFallback(this.app.get().fallbackApp);
                this.deployParams.setSwingAppWithEmbeddedJavaFX(this.app.get().embeddedIntoSwing);
                this.deployParams.setVersion(this.app.get().version);
                this.deployParams.setId(this.app.get().id);
                this.deployParams.setServiceHint(this.app.get().daemon);
                this.setRuntime();
            }
            this.setAppInfo();
            this.setPlatform();
            this.setPreferences();
        }
        if (!(isModular || this.nativeBundles != Bundler.BundleType.NATIVE && this.nativeBundles != Bundler.BundleType.IMAGE && this.nativeBundles != Bundler.BundleType.INSTALLER && this.nativeBundles != Bundler.BundleType.ALL)) {
            if (this.app != null) {
                this.deployParams.setApplicationClass(this.app.get().mainClass);
                this.deployParams.setPreloader(this.app.get().preloaderClass);
                this.deployParams.setAppId(this.app.get().id);
                this.deployParams.setAppName(this.app.get().name);
                this.deployParams.setParams(this.app.get().parameters);
                this.deployParams.setArguments(this.app.get().getArguments());
                this.deployParams.setHtmlParams(this.app.get().htmlParameters);
                this.deployParams.setFallback(this.app.get().fallbackApp);
                this.deployParams.setSwingAppWithEmbeddedJavaFX(this.app.get().embeddedIntoSwing);
                this.deployParams.setVersion(this.app.get().version);
                this.deployParams.setId(this.app.get().id);
                this.deployParams.setServiceHint(this.app.get().daemon);
                this.setRuntime();
            }
            this.setAppInfo();
            this.setPlatform();
            this.setPreferences();
        }
        for (BundleArgument bundleArgument : this.bundleArgumentList) {
            this.deployParams.addBundleArgument(bundleArgument.arg, (Object)bundleArgument.value);
        }
        this.deployParams.setPlaceholder(this.placeholder);
        if (this.resources != null) {
            for (FileSet fileSet : this.resources.getResources()) {
                Utils.addResources(this.deployParams, fileSet);
            }
        }
        ArrayList<Map<String, ? super Object>> launchersAsMap = new ArrayList<Map<String, ? super Object>>();
        for (SecondaryLauncher sl : this.secondaryLaunchers) {
            launchersAsMap.add(sl.createLauncherMap());
        }
        this.deployParams.addBundleArgument(StandardBundlerParam.SECONDARY_LAUNCHERS.getID(), launchersAsMap);
        this.deployParams.setBundleType(this.nativeBundles);
        this.deployParams.setTargetFormat(this.bundleFormat);
        Log.setLogger((Log.Logger)new AntLog(this.getProject()));
        try {
            this.packager.generateDeploymentPackages(this.deployParams);
        }
        catch (PackagerException packagerException) {
            if (packagerException.getCause() != null) {
                throw new BuildException(packagerException.getCause().getMessage(), packagerException.getCause());
            }
            throw new BuildException(packagerException.getMessage(), (Throwable)packagerException);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            Log.setLogger(null);
        }
    }

    private void setRuntime() {
        if (this.runtime != null) {
            Boolean detectModules;
            for (String s : this.runtime.getAddModules()) {
                this.deployParams.addAddModule(s);
            }
            for (String s : this.runtime.getLimitModules()) {
                this.deployParams.addLimitModule(s);
            }
            this.deployParams.setModulePath(this.runtime.getModulePath());
            Boolean stripNativeCommands = this.runtime.getStripNativeCommands();
            if (stripNativeCommands != null) {
                this.deployParams.setStripNativeCommands(stripNativeCommands.booleanValue());
            }
            if ((detectModules = this.runtime.getDetectModules()) != null) {
                this.deployParams.setDetectModules(detectModules.booleanValue());
            }
        }
    }

    public void setExtension(boolean v) {
        this.isExtension = v;
    }

    public void setNativeBundles(String v) {
        Bundler.Bundle bundle = Bundler.stringToBundle((String)v);
        this.nativeBundles = bundle.type;
        this.bundleFormat = bundle.format;
    }

    public void setVersionCheck(String value) {
        this.versionCheck = Boolean.valueOf(value);
    }

    public void setUpdateMode(String v) {
        String l = v.toLowerCase();
        if ("eager".equals(l)) {
            l = "always";
        }
        if (!("always".equals(l) || "background".equals(l) || "timeout".equals(l))) {
            throw new BuildException("Unknown update mode: [" + l + "].Supported modes are: 'always', 'timeout' and 'background'");
        }
        this.updateMode = l;
    }

    public void setOfflineAllowed(boolean v) {
        this.offlineAllowed = v;
    }

    public void setEmbeddedWidth(String w) {
        this.embeddedWidth = w;
    }

    public void setWidth(String v) {
        this.width = v;
    }

    public void setEmbeddedHeight(String w) {
        this.embeddedHeight = w;
    }

    public void setHeight(String v) {
        this.height = v;
    }

    public void setEmbedJNLP(boolean v) {
        this.embedJNLP = v;
    }

    public void setOutdir(String v) {
        this.outdir = v;
    }

    public void setOutfile(String v) {
        this.outfile = v;
    }

    public void setIncludeDT(Boolean v) {
        this.includeDT = v;
    }

    public void setPlaceholderRef(String p) {
        this.placeholder = p;
    }

    public void setPlaceholderId(String id) {
        this.placeholder = "'" + id + "'";
    }

    public void setSignBundle(boolean signBundle) {
        this.signBundle = signBundle;
    }

    public Info createInfo() {
        this.appInfo = new Info();
        return this.appInfo;
    }

    public Application createApplication() {
        this.app = new Application();
        return this.app;
    }

    public Preferences createPreferences() {
        this.prefs = new Preferences();
        return this.prefs;
    }

    public Callbacks createCallbacks() {
        if (this.callbacks != null) {
            throw new BuildException("Only one callbacks element is supported.");
        }
        this.callbacks = new Callbacks();
        return this.callbacks;
    }

    public Resources createResources() {
        if (this.resources != null) {
            throw new BuildException("Only one resources element is supported.");
        }
        this.resources = new Resources();
        return this.resources;
    }

    public Template createTemplate() {
        Template t = new Template();
        this.templateList.add(t);
        return t;
    }

    public Platform createPlatform() {
        this.platform = new Platform();
        return this.platform;
    }

    public Permissions createPermissions() {
        this.perms = new Permissions();
        return this.perms;
    }

    public BundleArgument createBundleArgument() {
        BundleArgument ba = new BundleArgument();
        this.bundleArgumentList.add(ba);
        return ba;
    }

    public SecondaryLauncher createSecondaryLauncher() {
        SecondaryLauncher sl = new SecondaryLauncher();
        this.secondaryLaunchers.add(sl);
        return sl;
    }

    public Runtime createRuntime() {
        this.runtime = new Runtime();
        return this.runtime;
    }

    public void setDynamicAttribute(String name, String value) throws BuildException {
        this.bundleArgumentList.add(new BundleArgument(name, value));
    }

    private void setPlatform() {
        if (this.platform != null) {
            Platform pl = this.platform.get();
            if (pl.j2se != null) {
                this.deployParams.setJRE(pl.j2se);
            }
            if (pl.javafx != null) {
                this.deployParams.setJavafx(pl.javafx);
            }
            if (pl.javaRoot != null) {
                if ("".equals(pl.javaRoot)) {
                    this.deployParams.setJavaRuntimeSource(null);
                } else {
                    this.deployParams.setJavaRuntimeSource(new File(pl.javaRoot));
                }
            }
            for (Platform.Property property : pl.properties) {
                this.deployParams.addJvmProperty(property.name, property.value);
            }
            for (Platform.Jvmarg jvmarg : pl.jvmargs) {
                this.deployParams.addJvmArg(jvmarg.value);
            }
            for (Platform.Property property : pl.jvmUserArgs) {
                this.deployParams.addJvmUserArg(property.name, property.value);
            }
        }
    }

    private void setPreferences() {
        if (this.prefs != null) {
            this.deployParams.setNeedShortcut(this.prefs.getShortcut());
            this.deployParams.setNeedInstall(this.prefs.getInstall());
            this.deployParams.setNeedMenu(this.prefs.getMenu());
            this.deployParams.setSystemWide(this.prefs.getSystemInstall());
            this.deployParams.setInstalldirChooser(this.prefs.getInstalldirChooser());
            this.deployParams.setSingleton(this.prefs.getSingleton());
        }
    }

    private void setAppInfo() {
        if (this.appInfo != null) {
            this.deployParams.setTitle(this.appInfo.title);
            this.deployParams.setVendor(this.appInfo.vendor);
            this.deployParams.setDescription(this.appInfo.appDescription);
            this.deployParams.setCategory(this.appInfo.category);
            this.deployParams.setLicenseType(this.appInfo.licenseType);
            this.deployParams.setCopyright(this.appInfo.copyright);
            this.deployParams.setEmail(this.appInfo.email);
            for (Info.Icon i : this.appInfo.icons) {
                if (i instanceof Info.Splash) {
                    this.deployParams.addIcon(i.href, i.kind, i.width, i.height, i.depth, ((Info.Splash)i).mode);
                    continue;
                }
                this.deployParams.addIcon(i.href, i.kind, i.width, i.height, i.depth, DeployParams.RunMode.WEBSTART);
            }
            this.deployParams.addBundleArgument(StandardBundlerParam.FILE_ASSOCIATIONS.getID(), this.appInfo.fileAssociations.stream().map(FileAssociation::createLauncherMap).collect(Collectors.toList()));
        }
    }

    public static class BundleArgument
    extends DataType {
        String arg = null;
        String value = null;

        BundleArgument() {
        }

        BundleArgument(String arg, String value) {
            this.arg = arg;
            this.value = value;
        }

        public void setArg(String arg) {
            this.arg = arg;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Template
    extends DataType {
        File infile = null;
        File outfile = null;

        public void setFile(File f) {
            this.infile = f;
        }

        public void setTofile(File f) {
            this.outfile = f;
        }
    }
}

