/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.CachedParameterMetaData;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.spi.JDBCColumnDescriptorProvider;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOptions;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;

public class JDBCCallable
extends AbstractJDBCAction<ResultSet> {
    private final String sql;
    private final JsonArray in;
    private final JsonArray out;

    public JDBCCallable(JDBCStatementHelper helper, SQLOptions options, String sql, JsonArray in, JsonArray out) {
        super(helper, options);
        this.sql = sql;
        this.in = in;
        this.out = out;
    }

    @Override
    public ResultSet execute(Connection conn) throws SQLException {
        try (CallableStatement statement = conn.prepareCall(this.sql);){
            this.applyStatementOptions(statement);
            this.fillStatement(statement, this.in, this.out);
            boolean retResult = statement.execute();
            boolean outResult = this.out != null && this.out.size() > 0;
            ResultSet resultSet = null;
            if (retResult) {
                ResultSet ref = null;
                while (retResult) {
                    try (java.sql.ResultSet rs = statement.getResultSet();){
                        if (ref == null) {
                            ref = resultSet = this.asList(rs);
                        } else {
                            ref.setNext(this.asList(rs));
                            ref = ref.getNext();
                        }
                        if (outResult) {
                            ref.setOutput(this.convertOutputs(statement));
                        }
                    }
                    retResult = statement.getMoreResults();
                }
            } else if (outResult) {
                resultSet = new ResultSet(Collections.emptyList(), Collections.emptyList(), null).setOutput(this.convertOutputs(statement));
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
    }

    private JsonArray convertOutputs(CallableStatement statement) throws SQLException {
        JsonArray result = new JsonArray();
        CachedParameterMetaData md = new CachedParameterMetaData(statement);
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromParameterMetaData(md);
        for (int i = 0; i < this.out.size(); ++i) {
            Object var = this.out.getValue(i);
            if (var != null) {
                Object value = statement.getObject(i + 1);
                if (value == null) {
                    result.addNull();
                    continue;
                }
                if (value instanceof java.sql.ResultSet) {
                    result.add((Object)this.asList((java.sql.ResultSet)value).toJson());
                    continue;
                }
                result.add(this.helper.getDecoder().parse(statement, i + 1, provider));
                continue;
            }
            result.addNull();
        }
        return result;
    }
}

